-- 

USE master;
GO
EXEC sp_configure 'filestream_access_level', 2;
GO
RECONFIGURE;
GO

ALTER DATABASE BD_Air_France
      ADD FILEGROUP FG_Stream CONTAINS FILESTREAM;
GO

-- ajout d'un fichier dans ce nouveau groupe
-- il faut que C:\temp\sql-server existe 

ALTER DATABASE BD_Air_France
ADD FILE
   (NAME     = F_STREAM,
    FILENAME = 'C:\temp\sql-server\file-tables') 
TO FILEGROUP FG_Stream;
GO

ALTER DATABASE BD_Air_France
SET FILESTREAM 
   (NON_TRANSACTED_ACCESS = FULL, DIRECTORY_NAME = 'Avions_FS')
GO

USE BD_Air_France;

CREATE TABLE Avion_Documents AS FileTable;
GO

SELECT * FROM dbo.Avion_Documents;
GO

-- mettre les fichiers dans ce rep.

UPDATE dbo.Avion_Documents
SET    is_readonly = 1
WHERE  name = 'A340.txt';
GO

DELETE FROM dbo.Avion_Documents
WHERE  name = 'B737.txt';
GO

Create FullText Catalog 
catalogue_texte as Default;
GO

Create FullText Index on dbo.Avion_Documents
(name Language 1033, 
File_stream type column file_type Language 1033)
key Index PK__Avion_Do__5A5B77D5FEEBADF5
on catalogue_texte 
with Change_Tracking Auto, StopList=system;
Go


SELECT file_stream.GetFileNamespacePath(1,1) AS "Chemin"
FROM  dbo.Avion_Documents a
WHERE CONTAINS(a.file_stream,'NEAR(King, pratt-wittney)');
GO

